import React, {useState, useEffect} from "react";
import { View, Text } from "react-native";
import styles from "./ProfileCardStyles";
import { acronym } from "../../../../helper/acronym";
import dpr from "../../../../screens/Utilities/CustomStyleAttribute/dpr";
import CustomRating from "../../../../screens/Utilities/CustomRating/CustomRating";
import { round } from "../../../../helper/ratingRound";
import ProgressiveImage from "../../ProgressiveImage";
import { useSelector } from "react-redux";
import useLangTranslation from "../../../../hooks/useLangTranslation";

const ProfileCard = ({ vendor = {}, isVendor, navigation }) => {
    const { trans } = useLangTranslation();
    const {  vendorProfileInfo } = useSelector(
        (state) => state.vendorProfile
    );
    const [isTopSeller, setIsTopSeller] = useState(false);
    const { id, name, rating, total_review, logo } = vendor;

    useEffect(() => {
        if (vendorProfileInfo?.topSellerIds) {
            setIsTopSeller(vendorProfileInfo?.topSellerIds.includes(id));
        }
    }, [vendorProfileInfo?.topSellerIds]);

    return (
        <View style={styles.container}>
            <View>
                {isTopSeller && <Text style={styles.sellerBadge}>{trans("Top Seller")}</Text>}
                <Text style={styles.ownerName}>{name}</Text>
                <View style={styles.ratingCont}>
                    <CustomRating
                        rating={rating == null ? 0 : round(rating)}
                        starSize={dpr(18)}
                        readOnly={true}
                    />
                    <View style={styles.ratingCont}>
                        <Text style={styles.ratingText}>
                            {rating == null ? 0 : round(rating)}
                        </Text>
                        <Text style={styles.soldBy}>
                            (
                            {total_review == 1
                                ? `${total_review} ${trans("Review")}`
                                : `${total_review} ${trans("Reviews")}`}
                            )
                        </Text>
                    </View>
                </View>
            </View>
            <View>
                {logo?.trim().length ? (
                    <ProgressiveImage
                        source={{ uri: logo }}
                        style={styles.img}
                    />
                ) : (
                    <View style={styles.nameImage}>
                        <Text style={styles.nameImageText}>
                            {acronym(name)}
                        </Text>
                    </View>
                )}
            </View>
        </View>
    );
};

export default ProfileCard;
